
(* 1x1 1 xbot - DeleteTrajectory, SaveTrajectory, ReadTrajectoryHash. Trajectory file 'TrajectoryDemo.txt' must be in the root directory of the FileDevice *)
FUNCTION_BLOCK FileExample03_Trajectory
	//read trajectory file from disk
	Read_file(Execute := Execute,file_device := FileDevice,file_path := 'TrajectoryDemo.txt',data_adr := ADR(TrajData));

	//delete all trajectories from PMC
	PMC_DeleteTrajectory1(Execute := Read_file.Done,TrajID := 0,PM_Controller := PM_Controller);

	//deactivate PMC to allow uploading trajectory files
	PMC_Deactivatexbots1(Execute := PMC_DeleteTrajectory1.Done,PM_Controller := PM_Controller);

	//transfer trajectory file to PMC as trajectory 1
	PMC_SaveTrajectory1(Execute := PMC_Deactivatexbots1.Done,TrajID := 1,nBytes := Read_file.file_size,Axises := 63,TimeInterval := 0.010,Bytes := TrajData,PM_Controller := PM_Controller);

	//reactivate PMC after uploading the trajectory
	PMC_Activatexbots1(Execute := PMC_SaveTrajectory1.Done,PM_Controller := PM_Controller);

	//read the MD5 hash of trajectory 1 (should be 0x900D5E503988125A0FB99E7CB3ADFB86)
	PMC_ReadTrajectoryHash1(Execute := PMC_Activatexbots1.Done,TrajID := 1,PM_Controller := PM_Controller);

	//move xbot to starting position
	PMC_XYMotion1(Execute := PMC_ReadTrajectoryHash1.Valid,cmdLB := 0,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.12,PosY := 0.12,EndVel := 0,MaxVel := 1.0,MaxAcc := 10.0,PM_Controller := PM_Controller);

	//xbot 1 runs trajectory 1
	xbotID_array12[0] := 1;
	trajID_array12[0] := 1;
	PMC_ActivateTrajectory1(Execute := PMC_XYMotion1.Done,cmdLB := 0,nXbots := 1,XbotID := xbotID_array12,TrajID := trajID_array12,PM_Controller := PM_Controller);
	Done := PMC_ActivateTrajectory1.Done;
END_FUNCTION_BLOCK
